<!DOCTYPE html>
<!--
HTML template for generating a demo geospatial web app

AUTHOR:       Huidae Cho
COPYRIGHT:    (C) 2021 by Huidae Cho
LICENSE:      GNU Affero General Public License v3
-->
<html lang="en">
<head>
<title>Georgia Mapper</title>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
</head>
<body>
<h1>Welcome to My Georgia Mapper</h1>

<h2>{{map_name}}</h2>
<img src="{{map_name}}.png" />

<form action="/webmap/">
<input name="command" placeholder="Type your command" style="width:80%; max-width:50em" autofocus />
<input type="submit" value="Run" />
</form>

<p>{{map_info}}</p>

<h2>About</h2>

<p><a href="http://appdev.isnew.info/webmap/">This web map</a> was created as a class project for <a href="https://faculty.ung.edu/hcho/">Dr. Huidae Cho</a>&rsquo;s <a href="https://here.isnew.info/gisc-4500k.html">GISC 4500K - Application Development</a> course in <a href="https://here.isnew.info/gisc-4500k-2021-spring.html">Spring 2021</a>. It uses <a href="https://arc-garc.opendata.arcgis.com/datasets/dc20713282734a73abe990995de40497_68">data</a> from <a href="https://arc-garc.opendata.arcgis.com/">the Atlanta Regional Commission (ARC)</a> to display the population (totpop10), population density (totpop10 / Sq_Miles), and area (Sq_Miles) of a Georgia county.</p>

<p>The command syntax is very loose and flexible. A command will be parsed as follows:<p>
<ol>
<li>Strip out excessive whitespaces from its beginning and end.</li>
<li>Compress multiple whitespaces to single ones in the middle.</li>
<li>If it starts with &ldquo;add&rdquo; case-insensitively, the following syntax is expected: Add latitude, longitude Note
<ul>
<li>This command will create a new point and label it with Note.</li>
<li>Go back to step 1.</li>
</ul></li>
<li>Convert the command to lowercase.</li>
<li>Delete an apostrophe followed by an &lsquo;s&rsquo;, non-alphanumeric characters, and any words starting with &ldquo;county&rdquo;, &ldquo;map&rdquo;, or &ldquo;is&rdquo;.</li>
<li>Move &ldquo;population&rdquo;, &ldquo;population density&rdquo;, and &ldquo;area&rdquo; at the end of the command, if any, to the front.</li>
<li>If the command is empty, the initial welcome page will be displayed and go to step 1.</li>
<li>If the command contains &ldquo;population density&rdquo;, a population density will be displayed later.</li>
<li>If the command contains &ldquo;population&rdquo;, a population will be displayed later.</li>
<li>If the command contains &ldquo;area&rdquo;, an area will be displayed later.</li>
<li>If the command contains none of the above three, no additional information will be displayed later.</li>
<li>If the last word in the command is &ldquo;state&rdquo; or &ldquo;georgia&rdquo;, the initial welcome page will be displayed and go to step 1.</li>
<li>The last word is now considered the name of a county in Georgia. Show the map of this county and display additional information from one of steps 7&mdash;10.</li>
<li>Go to step 1.</li>
</ol>

<p>Try these commands:</p>
<ul>
<li>Show Fulton county!</li>
<li>Show me the Fulton map.</li>
<li>What is the population of Fulton county?</li>
<li>Fulton's population</li>
<li>What about the population density of Fulton county?</li>
<li>Fulton population density is?</li>
<li>Fulton county's area?</li>
<li>What is Fulton's area?</li>
<li>Add 33.8, -84.4 Roadkill 5/1/2021 at 5:12pm</li>
<li>Back to Georgia</li>
<li>State</li>
</ul>

<p>Point data added by the Add command will be deleted hourly.</p>
</body>
</html>
